﻿/* Skript zur Demonstration von MVs
 * Als Benutzer SCOTT ausführen
 */

-- Erstellung einer einfachen MV
create materialized view emp_mv 
refresh complete on demand
start with sysdate
next trunc(sysdate) + interval '1 1' day to hour
as
select e.ename mitarbeiter,
       d.dname abteilung,
       m.ename manager,
       e.job beruf,
       s.grade gehaltsstufe
  from emp e
  join dept d on e.deptno = d.deptno
  left join emp m on e.mgr = m.empno
  join salgrade s
    on e.sal between s.losal and s.hisal;

-- Ausführungspläne zweier identischer Abfragen, einmal gegen eine
-- View, einmal gegen eine MV
set autotrace on
select mitarbeiter, abteilung
  from emp_mv;
  
select mitarbeiter, abteilung
  from emp_vw;
  
set autotrace off

-- einfache MV mit inkrementeller Aktualisierung
create materialized view log on emp
  with primary key;
  
create materialized view emp_dept_20_mv
refresh fast on commit
as
select empno, ename, job, sal, hiredate, deptno
  from emp
 where deptno = 20;
 
-- Prüfung der MV
insert into emp (empno, ename, job, deptno)
values (8100, 'MEYER', 'ANALYST', 20);

commit;

select *
  from emp_dept_20_mv;

-- Erstellung einer komplexen MV: Erläuterung, warum eine MV nicht inkrementell aktualisierbar ist
create materialized view log on dept
  with primary key;
  
create materialized view log on salgrade
  with rowid;

-- Abfrage der Möglichkeiten unserer geplanten MV
delete mv_capabilities_table;
  
call dbms_mview.explain_mview(
'select e.empno, e.ename mitarbeiter,
        d.deptno, d.dname abteilung,
        m.ename manager,
        e.job beruf,
        s.grade gehaltsstufe
   from emp e, emp m, dept d, salgrade s
  where e.deptno = d.deptno
    and e.mgr = m.empno (+)
    and e.sal between s.losal and s.hisal');
    
select capability_name, possible, related_text, msgtxt
  from mv_capabilities_table
 where capability_name not like '%PCT%'
 order by seq;

-- Erster Umbau: Neugestaltung der MV Logs
drop materialized view log on emp;

drop materialized view log on dept;
  
create materialized view log on emp
  with primary key, rowid;
  
create materialized view log on dept
  with primary key, rowid;

-- Zweiter Umbau: Geänderte SQL-Abfrage

delete mv_capabilities_table;
  
call dbms_mview.explain_mview(
'select e.rowid e_rowid, e.ename mitarbeiter,
        d.rowid d_rowid, d.dname abteilung,
        m.rowid m_rowid, m.ename manager, 
        e.job beruf,
        s.rowid s_rowid, s.grade gehaltsstufe
   from emp e, emp m, dept d, salgrade s
  where e.deptno = d.deptno
    and e.mgr = m.empno (+)
    and e.sal between s.losal and s.hisal');
    
select capability_name, possible, related_text, msgtxt
  from mv_capabilities_table
 where capability_name not like '%PCT%'
 order by seq;

-- Erzeugung der MV
drop materialized view emp_mv;

create materialized view emp_mv
refresh fast on commit
as
select e.rowid e_rowid, e.ename mitarbeiter,
       d.rowid d_rowid, d.dname abteilung,
       m.rowid m_rowid, m.ename manager, 
       e.job beruf,
       s.rowid s_rowid, s.grade gehaltsstufe
  from emp e, emp m, dept d, salgrade s
 where e.deptno = d.deptno
   and e.mgr = m.empno (+)
   and e.sal between s.losal and s.hisal;

-- Wrapper-View, um die ROWID-Spalten auszublenden
create or replace view emp_vw as
select mitarbeiter, abteilung, manager, beruf, gehaltsstufe
  from emp_mv;

